-- Midway -  WW II ADC Team
mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_texture_path  (current_mod_path.."/Textures/IT_Liner.zip")


GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "large italian liner"
GT.visual.shape_dstr = ""
GT.animation_arguments.radar1_rotation = 11; --   1

GT.animation_arguments.luna_lights = 100;

GT.life = 70000
GT.mass = 7.05e+007
GT.max_velocity = 16.4622
GT.race_velocity = 15.4333
GT.economy_velocity = 9.26
GT.economy_distance = 1.4816e+007
GT.race_distance = 4.63e+006
GT.shipLength = 304.5
GT.Width = 42
GT.Height = 53.1
GT.Length = 304.5
GT.DeckLevel = 16.257
----- Scia di Prua
GT.X_nose = 110.326
----- scia di poppa
GT.X_tail = -110.339
GT.Tail_Width = 35
GT.Gamma_max = 0.35
GT.Om = 0.05
GT.speedup = 0.148333
GT.R_min = 609
GT.distFindObstacles = 963.5

GT.numParking = 4;
GT.Plane_Num_ = 72;
GT.Helicopter_Num_ = 6;

GT.airWeaponDist = 15000;
GT.airFindDist = 30000;

GT.exhaust = 
{
	[1] = { size = 0.75 , pos = {-2.032,9.5, 19 } },
 }

---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra
				
GT.cord_points = {
---		 {-57.589,   16.683, -21.694},   {-89.261,   16.683, 7.259},
		 {-57.589,   18, -3.0},   {-89.261,   16.683, 7.5},   -- da prua: quarto cavo di arresto.
        {-45.03,   16.683, -23.633},     {-77.702,   16.683, 5.32},
        {-33.205,   16.683, -24.952},   {-65.877,   16.683, 4.001},
        {-20.573,    16.683, -26.578},  {-53.142,   16.683, 2.375},  
	     }				

---GT.Landing_Point = {71.0, 16.26,-30.0} --{71.0, 16.26,-30.0}  
GT.Landing_Point = {71.0, 16.26,-30.0} --{71.0, 16.26,-30.0}  

GT.LSOPosition = {0.0, 17.0, 16.65, 8.8, 0.0} --{81.236, 24.0, 28.497, 10.0, 0.0} 

GT.DM = {
----- Scafo.
	{ area_name = "Scafo_Prua_Dx",			area_arg = 76,	area_life = 100, area_fire = { pos = {75.0, 4.0, 8.0}, size = 1.5}},
	{ area_name = "Scafo_Centrale_Dx",		area_arg = 71,	area_life = 100, area_fire = { pos = {20.0,  2.0, 13.0}, size = 1.5}},
	{ area_name = "Scafo_Centrale2_Dx",		area_arg = 95,	area_life = 100, area_fire = { pos = {20.0,  2.0, 13.0}, size = 1.5}},	
	{ area_name = "Scafo_Poppa_Dx", 		area_arg = 72,	area_life = 100, area_fire = { pos = {-70.0, 2.0, 8.0}, size = 1.5}},
	{ area_name = "Scafo_Prua_Sx", 		   	area_arg = 73,	area_life = 100, area_fire = { pos = {90.0, 4.0, -10.0}, size = 1.5}},
	{ area_name = "Scafo_Centrale_Sx", 		area_arg = 74,	area_life = 100, area_fire = { pos = {0.0,  2.0, -13.0}, size = 1.5}},
	{ area_name = "Scafo_Centrale2_Sx", 	area_arg = 94,	area_life = 100, area_fire = { pos = {0.0,  2.0, -13.0}, size = 1.5}},
	{ area_name = "Scafo_Poppa_Sx", 		area_arg = 75,	area_life = 100, area_fire = { pos = {-100.0, 2.0, -10.5}, size = 1.5}},
-------- Sovrastrutture	
	{ area_name = "Zona_Fumaiolo",          area_arg = 77,	area_life = 60,  area_fire = { pos = {0.5, 12.0, 0.0}, size = 2.5}},
	{ area_name = "Strutture_Poppa",       	area_arg = 82,	area_life = 200, area_fire = { pos = {-23.0, 12.0, 0.0}, size = 1.5}},
	{ area_name = "Sala_Comando",	        area_arg = 83,	area_life = 150, area_fire = { pos = {15.0, 12.0, 0.0}, size = 2.5}},
		
--------- 4 Torri Binate da 380mm	
	{ area_name = "Torre_380_Anton",		area_arg = 96,	area_life = 60, area_fire = { pos = {55.0, 11.0, 0.0}, size =  1.5}},
	{ area_name = "Torre_380_Bruno",		area_arg = 98,	area_life = 60, area_fire = { pos = {35.0, 14.0, 0.0}, size =  1.5}},  
	{ area_name = "Torre_380_Cesare",		area_arg = 70,	area_life = 60, area_fire = { pos = {-64.0, 14.0, 0.0}, size = 1.5}},
	{ area_name = "Torre_380_Dora",		    area_arg = 99,	area_life = 60, area_fire = { pos = {-62.0, 11.0, 0.0}, size = 1.5}},  

	{ area_name = "Ponte Prua",	           	area_arg = 84,	area_life = 60, area_fire = { pos = {67.0, 11.0, 0.0}, size =  1.5}},
    { area_name = "Ponte Poppa",			area_arg = 85,	area_life = 60, area_fire = { pos = {-95.0, 11.0, 0.0}, size = 1.5}}, 

}

--------------------------------------------------------------------------------------
---  Descrizioni Armamento 
--------------------------------------------------------------------------------------

-- Source for modifications: https://en.wikipedia.org/wiki/North_Carolina-class_battleship
-- Oerlikon (20 mm) naval AAA weapons. Source: https://en.wikipedia.org/wiki/Oerlikon_20_mm_cannon
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_Oerlikon_20 = {name = "20 mm Oerlikon"};
GT_t.WS_t.ship_Oerlikon_20.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-15), math.rad(90)},
                    };
GT_t.WS_t.ship_Oerlikon_20.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_Oerlikon_20.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_Oerlikon_20.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Oerlikon_20.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Oerlikon_20.reference_angle_Z = 0
GT_t.WS_t.ship_Oerlikon_20.LN = {}
GT_t.WS_t.ship_Oerlikon_20.LN[1] = {}
GT_t.WS_t.ship_Oerlikon_20.LN[1].type = 3
GT_t.WS_t.ship_Oerlikon_20.LN[1].distanceMin = 10
GT_t.WS_t.ship_Oerlikon_20.LN[1].distanceMax = 1500 -- effective shooting with 3600 meters
GT_t.WS_t.ship_Oerlikon_20.LN[1].max_trg_alt = 1000
GT_t.WS_t.ship_Oerlikon_20.LN[1].reactionTime = 1.8
GT_t.WS_t.ship_Oerlikon_20.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_Oerlikon_20.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_Oerlikon_20.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL = {}
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1] = {}
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1].ammo_capacity = 1550;
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1].shell_name = {"Rh202_20_AP", "Rh202_20_HE"};
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1].shell_display_name = "20mm AP+HE";
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1].shot_delay = 60/450 -- 450 rounds per minute average
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_Oerlikon_20.LN[1].BR = { {pos = {3.478, 0, 0} }, }



-- Bofors Mk 12 (40 mm) naval AAA weapons. Source: https://en.wikipedia.org/wiki/Bofors_40_mm_gun
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_Bofors_40_Mk_12 = {name = "40 mm Bofors Mk 12"};
GT_t.WS_t.ship_Bofors_40_Mk_12.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-5), math.rad(90)},
                    };
GT_t.WS_t.ship_Bofors_40_Mk_12.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_Bofors_40_Mk_12.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_Bofors_40_Mk_12.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Bofors_40_Mk_12.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Bofors_40_Mk_12.reference_angle_Z = 0
GT_t.WS_t.ship_Bofors_40_Mk_12.LN = {}
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1] = {}
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].type = 3
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].distanceMin = 10
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].distanceMax = 7160 -- effective shooting
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].max_trg_alt = 3800
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].reactionTime = 1.8
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL = {}
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1] = {}
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1].ammo_capacity = 560;
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1].shell_name = {"Boforos_40_Mk12_HE"};
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1].shell_display_name = "40mm HE";
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1].shot_delay = 60/120 -- 120 rpm
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].BR = { {pos = {3.478, 0, 0} }, }


-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 150mm
-------------------------------------------------------------------------------------------------
-- 38 Caliber Mark 12 (127 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/5%22/38_caliber_gun
-- Used default FMC5 MK45 127mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_38cal_Mk12 = {name = "127 mm Mark 12"}
GT_t.WS_t.ship_38cal_Mk12.angles = {
					{math.rad(164.25), math.rad(-164.25), math.rad(-15), math.rad(85)},
					};
GT_t.WS_t.ship_38cal_Mk12.omegaY = 0.6
GT_t.WS_t.ship_38cal_Mk12.omegaZ = 0.6
GT_t.WS_t.ship_38cal_Mk12.reference_angle_Z = 0
GT_t.WS_t.ship_38cal_Mk12.LN = {}
GT_t.WS_t.ship_38cal_Mk12.LN[1] = {}
GT_t.WS_t.ship_38cal_Mk12.LN[1].type = 6
GT_t.WS_t.ship_38cal_Mk12.LN[1].xc = 3
GT_t.WS_t.ship_38cal_Mk12.LN[1].distanceMin = 50
GT_t.WS_t.ship_38cal_Mk12.LN[1].max_trg_alt = 7500
GT_t.WS_t.ship_38cal_Mk12.LN[1].reactionTime = 15
GT_t.WS_t.ship_38cal_Mk12.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_38cal_Mk12.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_38cal_Mk12.LN[1].PL = {}
GT_t.WS_t.ship_38cal_Mk12.LN[1].PL[1] = {}
GT_t.WS_t.ship_38cal_Mk12.LN[1].PL[1].ammo_capacity = 240 -- Currently uses same ammo count as SK_C_38
GT_t.WS_t.ship_38cal_Mk12.LN[1].PL[1].shell_name = {"MK45_127"}; -- Currently uses MK45 127 mm shells (127 mm ammo is WIP)
GT_t.WS_t.ship_38cal_Mk12.LN[1].PL[1].shot_delay = 60/15 -- (15 rounds per minute per barrel - average)
GT_t.WS_t.ship_38cal_Mk12.LN[1].automaticLoader = false;
GT_t.WS_t.ship_38cal_Mk12.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_38cal_Mk12.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, -0.1} } }


-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 406mm
-------------------------------------------------------------------------------------------------
-- 45 Caliber Mark 6 (406 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/16%22/45_caliber_Mark_6_gun
-- Used default AK130 130mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_45cal_Mk6 = {name = "406 mm Mark 6"}
GT_t.WS_t.ship_45cal_Mk6.angles = {
					{math.rad(150), math.rad(-150), math.rad(-2), math.rad(45)},
					};
GT_t.WS_t.ship_45cal_Mk6.omegaY = 0.6
GT_t.WS_t.ship_45cal_Mk6.omegaZ = 0.6
GT_t.WS_t.ship_45cal_Mk6.reference_angle_Z = 0
GT_t.WS_t.ship_45cal_Mk6.LN = {}
GT_t.WS_t.ship_45cal_Mk6.LN[1] = {}
GT_t.WS_t.ship_45cal_Mk6.LN[1].type = 6
GT_t.WS_t.ship_45cal_Mk6.LN[1].distanceMin = 50
GT_t.WS_t.ship_45cal_Mk6.LN[1].max_trg_alt = 20
GT_t.WS_t.ship_45cal_Mk6.LN[1].reactionTime = 15
GT_t.WS_t.ship_45cal_Mk6.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_45cal_Mk6.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_45cal_Mk6.LN[1].PL = {}
GT_t.WS_t.ship_45cal_Mk6.LN[1].PL[1] = {}
GT_t.WS_t.ship_45cal_Mk6.LN[1].PL[1].ammo_capacity = 240
GT_t.WS_t.ship_45cal_Mk6.LN[1].PL[1].shell_name = {"A222_130"}; -- Currently uses A222 130 mm shells (406 mm ammo is WIP)
--GT_t.WS_t.ship_45cal_Mk6.LN[1].PL[1].shell_name = {"Shell_406mm"};

GT_t.WS_t.ship_45cal_Mk6.LN[1].PL[1].shot_delay = 60/2 -- (2 rounds per minute per barrel - average)
GT_t.WS_t.ship_45cal_Mk6.LN[1].automaticLoader = false;
GT_t.WS_t.ship_45cal_Mk6.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_45cal_Mk6.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, 0.0} }, {pos = {8, 0, -0.1} } }


-------------------------------------------------------------------------------------
--  Start Weapons systems
-------------------------------------------------------------------------------------
-- weapon systems
GT.WS = {}
local ws;
GT.WS.maxTargetDetectionRange = 450000;
GT.WS.radar_type = 102

-----------------------------------------------------------------------------------------------------------
---------- *************** 5 turrets with  double cannons 127mm   ****************---------------
-----------------------------------------------------------------------------------------------------------
--[[
--- 1)  130mm turret turned towards the bow---------------------
-- Note: Currently can fire up to about 23 km in range with 127 mm shells from default FMC5 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_38cal_Mk12 )
GT.WS[ws].area = 'Scafo_Prua_Sx'
GT.WS[ws].center = 'CENTER_TOWER_01'
GT.WS[ws].drawArgument1 = 19
GT.WS[ws].drawArgument2 = 20
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_HIR_MT_11',
		recoilArgument = 36,
	},
	{
		connector_name = 'POINT_HIR_MT_12',
		recoilArgument = 36,
	}
}



--- 2)  130mm turret turned towards the bow---------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_38cal_Mk12 )
GT.WS[ws].area = 'Scafo_Prua_Dx'
GT.WS[ws].center = 'CENTER_TOWER_02'
GT.WS[ws].drawArgument1 = 21
GT.WS[ws].drawArgument2 = 22
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_HIR_MT_21',
		recoilArgument = 37,
	},
	{
		connector_name = 'POINT_HIR_MT_22',
		recoilArgument = 37,
	}
}



--- 3)  130mm turret turned towards the bow---------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_38cal_Mk12 )
GT.WS[ws].area = 'Scafo_Centrale_Sx'
GT.WS[ws].center = 'CENTER_TOWER_03'
GT.WS[ws].drawArgument1 = 23
GT.WS[ws].drawArgument2 = 24
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(15);
GT.WS[ws].reference_angle_Y = math.rad(90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_HIR_MT_31',
		recoilArgument = 38,
	},
	{
		connector_name = 'POINT_HIR_MT_32',
		recoilArgument = 38,
	}
}


--- 4)  130mm turret turned towards the bow---------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_38cal_Mk12 )
GT.WS[ws].area = 'Scafo_Centrale_Dx'
GT.WS[ws].center = 'CENTER_TOWER_04'
GT.WS[ws].drawArgument1 = 25
GT.WS[ws].drawArgument2 = 26
GT.WS[ws].angles[1][1] = math.rad(-0);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_HIR_MT_41',
		recoilArgument = 39,
	},
	{
		connector_name = 'POINT_HIR_MT_42',
		recoilArgument = 39,
	}
}



--- 5)  130mm turret turned towards the bow---------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_38cal_Mk12 )
GT.WS[ws].area = 'Scafo_Centrale_Dx'
GT.WS[ws].center = 'CENTER_TOWER_05'
GT.WS[ws].drawArgument1 = 27
GT.WS[ws].drawArgument2 = 28
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(15);
GT.WS[ws].reference_angle_Y = math.rad(90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_HIR_MT_51',
		recoilArgument = 40,
	},
	{
		connector_name = 'POINT_HIR_MT_52',
		recoilArgument = 40,
	}
}


--- 6)  130mm turret turned towards the bow---------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_38cal_Mk12 )
GT.WS[ws].area = 'Scafo_Centrale_Dx'
GT.WS[ws].center = 'CENTER_TOWER_15'
GT.WS[ws].drawArgument1 = 29
GT.WS[ws].drawArgument2 = 30
GT.WS[ws].angles = {
					{math.rad(-10), math.rad(-170), math.rad(-2), math.rad(50)},
					};
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_HIR_MT_61',
		recoilArgument = 41,
	},
	{
		connector_name = 'POINT_HIR_MT_62',
		recoilArgument = 41,
	}
}


---------------------------------------------------------------------------------------------------------------------------------
---------- ***************   5  quad Bofors 40 mm guns    ****************------------------------
---------------------------------------------------------------------------------------------------------------------------------
--- 1)  three Bofors 40 mm guns - Left
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 )
GT.WS[ws].area = 'Scafo_Centrale_Sx'
GT.WS[ws].center = 'CENTER_TOWER_06'
GT.WS[ws].drawArgument1 = 49
GT.WS[ws].drawArgument2 = 50
--GT.WS[ws].angles[1][1] = math.rad(0);
--GT.WS[ws].angles[1][2] = math.rad(90);
GT.WS[ws].angles = {
					{math.rad(170), math.rad(10), math.rad(-5), math.rad(80)},
					};
GT.WS[ws].reference_angle_Y = math.rad(5);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_11',
		recoilArgument = 150,
	},
	{
		connector_name = 'POINT_Bofors_12',
		recoilArgument = 150,
	},
	{
		connector_name = 'POINT_Bofors_13',
		recoilArgument = 150,
	}
}

------------------------------------------------------------------------------------

--- 2)   three Bofors 40 mm guns - Right
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 )
GT.WS[ws].area = 'Scafo_Centrale_Dx'
GT.WS[ws].center = 'CENTER_TOWER_07'
GT.WS[ws].drawArgument1 = 51
GT.WS[ws].drawArgument2 = 52
--GT.WS[ws].angles[1][1] = math.rad(0);
--GT.WS[ws].angles[1][2] = math.rad(90);
GT.WS[ws].angles = {
					{math.rad(-10), math.rad(-170), math.rad(-5), math.rad(80)},
					};
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_21',
		recoilArgument = 151,
	},
	{
		connector_name = 'POINT_Bofors_22',
		recoilArgument = 151,
	},
	{
		connector_name = 'POINT_Bofors_23',
		recoilArgument = 151,
	}
}




--- 3)  quad Bofors 40 mm guns - left/aft
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_08'
GT.WS[ws].drawArgument1 = 53
GT.WS[ws].drawArgument2 = 54
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(15);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_31',
		recoilArgument = 153,
	},
	{
		connector_name = 'POINT_Bofors_32',
		recoilArgument = 153,
	},
	{
		connector_name = 'POINT_Bofors_33',
		recoilArgument = 153,
	}
}



--- 4)  quad Bofors 40 mm guns - right/aft
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_09'
GT.WS[ws].drawArgument1 = 55
GT.WS[ws].drawArgument2 = 56
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(15);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_41',
		recoilArgument = 155,
	},
	{
		connector_name = 'POINT_Bofors_42',
		recoilArgument = 155,
	},
	{
		connector_name = 'POINT_Bofors_43',
		recoilArgument = 155,
	}
}


--- 5)  quad Bofors 40 mm guns - right/aft
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_10'
GT.WS[ws].drawArgument1 = 57
GT.WS[ws].drawArgument2 = 58
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(15);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_51',
		recoilArgument = 157,
	},
	{
		connector_name = 'POINT_Bofors_52',
		recoilArgument = 157,
	},
	{
		connector_name = 'POINT_Bofors_53',
		recoilArgument = 157,
	}
}


---------------------------------------------------------------------------------------------------------------------------------
---------- ***************   3  trinate Bofors 40 mm guns    ****************------------------------
--------------------------------------------------------------------------------------------------
--- 1)  trinate Bofors 40 mm guns - Left
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_15'
GT.WS[ws].drawArgument1 = 123
GT.WS[ws].drawArgument2 = 124
GT.WS[ws].angles[1][1] = math.rad(-0);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_61',
		recoilArgument = 224,
	},
	{
		connector_name = 'POINT_Bofors_62',
		recoilArgument = 224,
	},
	{
		connector_name = 'POINT_Bofors_63',
		recoilArgument = 224,
	}
}

--- 2)  trinate Bofors 40 mm guns - Right
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_17'
GT.WS[ws].drawArgument1 = 125
GT.WS[ws].drawArgument2 = 126
GT.WS[ws].angles[1][1] = math.rad(-0);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_71',
		recoilArgument = 224,
	},
	{
		connector_name = 'POINT_Bofors_72',
		recoilArgument = 224,
	},
	{
		connector_name = 'POINT_Bofors_73',
		recoilArgument = 224,
	}
}


--- 3)  trinate Bofors 40 mm guns - Right
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_18'
GT.WS[ws].drawArgument1 = 127
GT.WS[ws].drawArgument2 = 128
GT.WS[ws].angles[1][1] = math.rad(-0);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_81',
		recoilArgument = 228,
	},
	{
		connector_name = 'POINT_Bofors_82',
		recoilArgument = 228,
	},
	{
		connector_name = 'POINT_Bofors_83',
		recoilArgument = 228,
	}
}
--------------------------------------------------------------------------------------------------------------------------------
---------- ***************   ?? Machine Gun 20mm    ****************------------------------
---------------------------------------------------------------------------------------------------------------------------------
--1) MGun Sx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Oerlikon_20 )
GT.WS[ws].area = 'Scafo_Prua_Sx'
GT.WS[ws].center = 'CENTER_TOWER_11'
GT.WS[ws].drawArgument1 = 59
GT.WS[ws].drawArgument2 = 60
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(90);  -- valore originale 90
GT.WS[ws].LN[1].fireAnimationArgument = 160;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MGun_11',
		recoilArgument = 160,
	},
	{
		connector_name = 'POINT_MGun_12',
		recoilArgument = 160,
	}
}


--2) MGun Dx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Oerlikon_20 )
GT.WS[ws].area = 'Scafo_Prua_Dx'
GT.WS[ws].center = 'CENTER_TOWER_12'
GT.WS[ws].drawArgument1 = 67
GT.WS[ws].drawArgument2 = 68
GT.WS[ws].angles[1][1] = math.rad(-10);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-90);  -- valore originale 90
GT.WS[ws].LN[1].fireAnimationArgument = 168;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MGun_21',
		recoilArgument = 168,
	},
	{
		connector_name = 'POINT_MGun_22',
		recoilArgument = 168,
	}
}

--3) MGun Dx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Oerlikon_20 )
GT.WS[ws].area = 'Scafo_Prua_Dx'
GT.WS[ws].center = 'CENTER_TOWER_13'
GT.WS[ws].drawArgument1 = 91
GT.WS[ws].drawArgument2 = 92
GT.WS[ws].angles[1][1] = math.rad(-10);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-90);  -- valore originale 90
GT.WS[ws].LN[1].fireAnimationArgument = 192;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MGun_31',
		recoilArgument = 192,
	},
	{
		connector_name = 'POINT_MGun_32',
		recoilArgument = 192,
	}
}


--4) MGun Dx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Oerlikon_20 )
GT.WS[ws].area = 'Scafo_Prua_Dx'
GT.WS[ws].center = 'CENTER_TOWER_14'
GT.WS[ws].drawArgument1 = 65
GT.WS[ws].drawArgument2 = 66
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(10);
GT.WS[ws].reference_angle_Y = math.rad(90);  -- valore originale 90
GT.WS[ws].LN[1].fireAnimationArgument = 166;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MGun_41',
		recoilArgument = 166,
	},
	{
		connector_name = 'POINT_MGun_42',
		recoilArgument = 166,
	}
}

--]]

------------------------------------------------------------------------------------------------------
--      Parte Finale                                                                                --
------------------------------------------------------------------------------------------------------

GT.Name = "large_italian_liner"
GT.DisplayName = _("RN large italian liner")
GT.Rate = 5500

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV"},
                RADAR = {
                    "seasparrow tr",
                    "carrier search radar",
                },
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="yes";
GT.mapclasskey = "P0091000065";
GT.attribute = {wsType_Navy,wsType_Ship,wsType_AirCarrier,
                    "Aircraft Carriers",
                    "cord",
                    "ski_jump",
                    "RADAR_BAND1_FOR_ARM",
				};
--[[GT.attribute = {wsType_Navy,wsType_Ship,wsType_AirCarrier,Kuznecow,
                    "Aircraft Carriers",
                    "cord",
                    "ski_jump",
                    "RADAR_BAND1_FOR_ARM",
				};	]]			
GT.Categories = {
					{name = "AircraftCarrier"},
					--{name = "AircraftCarrier With Tramplin"},
					{name = "AircraftCarrier With Catapult"},
					{name = "Armed Ship"},
				};
				
add_surface_unit(GT)				